/************************************************************************************************************\

Module Name:    Liberatus.h

Description:    Write description here.

References:     None.

    Copyright (c) 2009, Matrox Graphics Inc.
    All Rights Reserved.

\************************************************************************************************************/

#ifndef INC_LIBERATUS_H
#define INC_LIBERATUS_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------
#include "MtxBaseTypes.h"
#include "LTypes.h"
#include "LStatus.h"
#include "LAPI.h"
#include "LPixelFormat.h"

typedef struct LDEVICE_OBJECT*       LDevice_Handle;

#define LINFINITE_TIMEOUT                   MUINT32_MAX

// Liberatus Interface version
#define LIBERATUS_MAJOR                     0
#define LIBERATUS_MINOR                     39

// Liberatus run-time version may be use at run time, with Liberatus_Version()
// and the Macros :
// LIBERATUS_GET_MAJOR()
// LIBERATUS_GET_MINOR()
// LIBERATUS_GET_BUILD()
// N.B.: The build version may only be used at run-time.
#define LIBERATUS_MAJOR_MASK                0xFF000000
#define LIBERATUS_MINOR_MASK                0x00FF0000
#define LIBERATUS_BUILD_MASK                0x0000FFFF
#define LIBERATUS_MAJOR_SHIFT               24
#define LIBERATUS_MINOR_SHIFT               16
#define LIBERATUS_BUILD_SHIFT               0

#define LIBERATUS_GET_MAJOR(uiVersion)      ((uiVersion & LIBERATUS_MAJOR_MASK) >> LIBERATUS_MAJOR_SHIFT)
#define LIBERATUS_GET_MINOR(uiVersion)      ((uiVersion & LIBERATUS_MINOR_MASK) >> LIBERATUS_MINOR_SHIFT)
#define LIBERATUS_GET_BUILD(uiVersion)      ((uiVersion & LIBERATUS_BUILD_MASK) >> LIBERATUS_BUILD_SHIFT)
#define LIBERATUS_GET_VERSION(uiMajor,uiMinor,uiBuild)                  ( \
            ((uiMajor << LIBERATUS_MAJOR_SHIFT) & LIBERATUS_MAJOR_MASK) | \
            ((uiMinor << LIBERATUS_MINOR_SHIFT) & LIBERATUS_MINOR_MASK) | \
            ((uiBuild << LIBERATUS_BUILD_SHIFT) & LIBERATUS_BUILD_MASK) )

#include "LDeviceThread.h"
#include "LBuffer.h"

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------
// Standard Macros
// ----------------

#if defined (__cplusplus)
extern "C" {
#endif

LAPI void                       Liberatus_Load(void);       // To be defined in dll, or stub in static library
LAPI void                       Liberatus_LoadLite(void);   // To be defined in dll, or stub in static library
LAPI void                       Liberatus_UnLoad(void);     // To be defined in dll, or stub in static library

LAPI MUINT32                    Liberatus_Version(void);
LAPI MUINT32                    Liberatus_GetDeviceCount(void);
LAPI LDevice_Handle             Liberatus_GetDevice(MUINT32 iIndex);

#if defined (__cplusplus)
}
#endif

#endif  // #ifndef INC_LIBERATUS_H
